<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrderType extends Model 
{

    protected $table = 'order_types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'price');

    public function orders()
    {
        return $this->hasMany('Order');
    }

    public function sections()
    {
        return $this->hasMany('Section');
    }

}